# Dataset Card for LLM2Graph QA Dataset

## Dataset Summary
The dataset consists of question-answer pairs generated from automatically constructed knowledge graphs using LLMs. The dataset targets entities sampled from the `RWKU` and `TOFU` unlearning benchmark. Each QA pair is grounded on multi-hop subgraphs and categorized by reasoning type.

## Dataset Creation
- Graphs are constructed via LLM-elicited BFS over entities from `jinzhuoran/RWKU`.
- For each graph:
    - We extract multi-hop subgraphs.
    - We generate diverse question templates.
    - We instantiate these templates into concrete questions.


## Intended Use
- Benchmarking LLM multi-hop reasoning.
- Evaluating unlearning performance on knowledge-rich tasks.
- Fine-tuning or evaluating KG-grounded QA systems.

## License
MIT License (or your preferred open license)

## Limitations
- Knowledge is LLM-elicited and may not reflect real-world facts.
- Biases from base LLM may affect question formulations.
